
#include <SPI.h>
#include <unican_ard.h>

uint8_t leds[] = {22, 26, 27, 25, 24, 23}; // НОМЕРА ПИНОВ НА КОТОРЫХ РАСПОЛОЖЕНЫ СВЕТОДИОДЫ

uint8_t led_pin(uint8_t d_index) // ПОЛУЧИТЬ НОМЕР ПИНА ПО ИНДЕКСУ СВЕТОДИОДА (ИНДЕКСЫ СВЕТОДИОДОВ ОБОЗНАЧЕНЫ НА ПЛАТЕ КАК D9, D10, .., D14)
{
  switch (d_index)
  {
    case 9:
      return 24;
    case 10:
      return 25;
    case 11:
      return 22;
    case 12:
      return 23;
    case 13:
      return 26;
    case 14:
      return 27;
    default:
      return 0;
  }
}

#define LED_ON_MSGID  0xABC1 // MSGID ВКЛЮЧЕНИЯ СВЕТОДИОДА
#define LED_OFF_MSGID 0xABC0 // MSGID ВЫКЛЮЧЕНИЯ СВЕТОДИОДА

void setup() {
  // put your setup code here, to run once:
  Serial.begin (9600);
  Serial.println ("Hello World!");

  for (uint8_t i = 0; i < 6; i++)
  {
    pinMode(leds[i], OUTPUT);
  }
  
    UCanArd.Init(); // ИНИЦИАЛИЗАЦИЯ UNICAN

}

void loop() {
  // put your main code here, to run repeatedly:
  UCanArd.ReceiveTask(); // ПОЛУЧЕНИЕ CAN СООБЩЕНИЯ

  uint8_t from_id = 0;
  uint16_t msg_id = 0;
  uint8_t msg_length = 0;
  uint8_t data[100];
  int status = UCanArd.ReadMessage(&from_id, &msg_id, data, &msg_length); // ПРОВЕРЯЕМ ГОТОВНОСТЬ UNICAN СООБЩЕНИЯ
  if (status == 0)
  {
    if (msg_id == LED_ON_MSGID)
    {
      uint8_t led_index = data[0];
      if (led_pin(led_index) == 0)
      {
        Serial.print("Wrong led_index: ");
        Serial.println(led_index, DEC);
        UCanArd.SendNack(from_id); // ОТВЕЧАЕМ ОШИБКОЙ
      }
      else
      {
        digitalWrite(led_pin(led_index), HIGH);
        UCanArd.SendAck(from_id); // ПОДТВЕРЖДАЕМ ВАЛИДНОСТЬ
      }
    }
    else if (msg_id == LED_OFF_MSGID)
    {
      uint8_t led_index = data[0];
      if (led_pin(led_index) == 0)
      {
        Serial.print("Wrong led_index: ");
        Serial.println(led_index, DEC);
        union
        {
          uint16_t code;
          uint8_t buff[2];
        } parcel;
        parcel.code = led_index;
        UCanArd.SendMessage(from_id, 0x0119, parcel.buff, 2); // ДЛЯ ПРИМЕРА ОТПРАВКИ ПРОИЗВОЛЬНОГО UNICAN СООБЩЕНИЯ ОТПРАВИМ СООБЩЕНИЕ ПОВТОРЯЮЩЕЕ ФОРМАТ NACK (16-БИТНЫЙ БЕЗЗНАКОВЫЙ КОД, СООТВ. ДЛИНА РАВНА 2, А MSGID: 0x0119)
      }
      else
      {
        digitalWrite(led_pin(led_index), LOW);
        uint16_t code = led_index;
        union
        {
          uint16_t code;
          uint8_t buff[2];
        } parcel;
        parcel.code = led_index;
        UCanArd.SendMessage(from_id, 0x0118, parcel.buff, 2); // ДЛЯ ПРИМЕРА ОТПРАВКИ ПРОИЗВОЛЬНОГО UNICAN СООБЩЕНИЯ ОТПРАВИМ СООБЩЕНИЕ ПОВТОРЯЮЩЕЕ ФОРМАТ ACK (16-БИТНЫЙ БЕЗЗНАКОВЫЙ КОД, СООТВ. ДЛИНА РАВНА 2, А MSGID: 0x0118)
      }
    }
    else
    {
        Serial.print("Unknown msgid: ");
        Serial.println(msg_id, DEC);
    }
  }
  else // ЕСЛИ НЕТ ВХОДЯЩЕГО СООБЩЕНИЯ СРАЗУ ПЕРЕХОДИМ К СЛЕДУЮЩЕЙ ИТЕРАЦИИ ЦИКЛА, ЧТО ВАЖНО ДЛЯ ПОЛУЧЕНИЯ МНОГОКАДРОВЫХ СООБЩЕНИЙ
  {
    return;
  }
  
delay(50);
}
